/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.traceroute;

import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.snmp.SnmpPDUException;
import ibm.nways.jdm.snmp.SnmpSocketException;
import ibm.nways.jdm.snmp.SnmpUnknownHostException;
import ibm.nways.jdm.traceroute.Connection;
import ibm.nways.jdm.traceroute.MultiLinkConnection;
import ibm.nways.jdm.traceroute.NetInterface;
import ibm.nways.jdm.traceroute.Node;
import ibm.nways.jdm.traceroute.RemoteTraceException;
import ibm.nways.jdm.traceroute.StatusEvent;
import ibm.nways.jdm.traceroute.StatusListener;
import ibm.nways.jdm.traceroute.TraceRouteOptions;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Vector;

public class Path
implements Serializable {
    protected Node src;
    protected Node dest;
    protected boolean pathComplete;
    protected Vector finalPathList;
    protected Vector srcToDestPathList = new Vector(15, 5);
    protected Vector destToSrcPathList = new Vector(15, 5);
    protected Vector problemNodes;
    protected TraceRouteOptions options;
    protected transient Vector statusListeners;
    private static ResourceBundle strings = ResourceBundle.getBundle((class$ibm$nways$jdm$traceroute$TraceRouteResources != null ? class$ibm$nways$jdm$traceroute$TraceRouteResources : (class$ibm$nways$jdm$traceroute$TraceRouteResources = Path.class$("ibm.nways.jdm.traceroute.TraceRouteResources"))).getName());
    private static final boolean debug = false;
    static /* synthetic */ Class class$ibm$nways$jdm$traceroute$TraceRouteResources;

    public Path(Node node, Node node2) {
        this.finalPathList = new Vector();
        this.problemNodes = new Vector();
        this.src = node;
        this.dest = node2;
        this.pathComplete = false;
    }

    public void setOptions(TraceRouteOptions traceRouteOptions) {
        this.options = traceRouteOptions;
    }

    public Enumeration getConnections() {
        return this.finalPathList.elements();
    }

    public Enumeration getNodes() {
        return new NodeEnumeration();
    }

    public Enumeration getProblemNodes() {
        return this.problemNodes.elements();
    }

    public Node getSrcNode() {
        return this.src;
    }

    public Node getDestNode() {
        return this.dest;
    }

    public boolean pathComplete() {
        return this.pathComplete;
    }

    public void clearResponseTimes() {
        try {
            Enumeration enumeration = this.getConnections();
            while (enumeration.hasMoreElements()) {
                Connection connection = (Connection)enumeration.nextElement();
                connection.clearResponseTime();
            }
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public void calcResponseTimes() {
        try {
            Enumeration enumeration = this.getConnections();
            while (enumeration.hasMoreElements()) {
                Connection connection = (Connection)enumeration.nextElement();
                connection.getResponseTime();
            }
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public void findPath() {
        this.nextHopPathQuery(this.src, this.dest, this.srcToDestPathList);
        if (this.pathComplete) {
            this.setFinalPathList();
            return;
        }
        this.notifyStatusListeners(this, strings.getString("TracingBackwards"));
        this.nextHopPathQuery(this.dest, this.src, this.destToSrcPathList);
        this.setFinalPathList();
    }

    protected void nextHopPathQuery(Node node, Node node2, Vector vector) {
        try {
            this.notifyStatusListeners(node, String.valueOf(strings.getString("Querying")) + " " + node + " " + strings.getString("ForNextHop"));
            Object[] objectArray = node.getInterfaceAndNextHop(node2);
            NetInterface netInterface = (NetInterface)objectArray[0];
            Node node3 = (Node)objectArray[1];
            if (node3 == node2) {
                this.addConnection(new Connection(node, node3, netInterface), vector);
                this.pathComplete = true;
                if (vector == this.destToSrcPathList) {
                    this.srcToDestPathList.removeAllElements();
                }
                return;
            }
            if (node3.equals(node)) {
                this.notifyStatusListeners(node, String.valueOf(strings.getString("NextHopError")) + " " + node + ". " + strings.getString("RouteTableErrorText") + node3);
                return;
            }
            this.addConnection(new Connection(node, node3, netInterface), vector);
            if (!this.pathComplete) {
                this.nextHopPathQuery(node3, node2, vector);
                return;
            }
        }
        catch (SnmpUnknownHostException snmpUnknownHostException) {
            this.notifyStatusListeners(node, String.valueOf(strings.getString("NextHopError")) + " " + node + ". " + strings.getString("SnmpUnknownHostException"));
            this.problemNodes.addElement(node);
            return;
        }
        catch (SnmpSocketException snmpSocketException) {
            this.notifyStatusListeners(node, String.valueOf(strings.getString("NextHopError")) + " " + node + ". " + strings.getString("SnmpSocketException"));
            this.problemNodes.addElement(node);
            return;
        }
        catch (SnmpPDUException snmpPDUException) {
            this.notifyStatusListeners(node, String.valueOf(strings.getString("NextHopError")) + " " + node + ". " + snmpPDUException.getMessage());
            this.problemNodes.addElement(node);
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.notifyStatusListeners(node, String.valueOf(strings.getString("NextHopError")) + " " + node + ". " + strings.getString("RouteTableEmpty"));
            this.problemNodes.addElement(node);
            return;
        }
        catch (Exception exception) {
            this.notifyStatusListeners(node, String.valueOf(strings.getString("NextHopError")) + " " + node + ". " + exception);
            this.problemNodes.addElement(node);
            return;
        }
    }

    protected void addConnection(Connection connection, Vector vector) {
        Object e;
        vector.addElement(connection);
        Vector vector2 = vector == this.srcToDestPathList ? this.destToSrcPathList : this.srcToDestPathList;
        if (!vector2.isEmpty() && connection.isNeighbor((Connection)(e = vector2.lastElement()))) {
            this.pathComplete = true;
        }
    }

    protected void setFinalPathList() {
        Serializable serializable;
        Node node;
        this.finalPathList = (Vector)this.srcToDestPathList.clone();
        if (!this.pathComplete()) {
            node = this.getLastNode(this.srcToDestPathList, this.src);
            serializable = this.getLastNode(this.destToSrcPathList, this.dest);
            MultiLinkConnection multiLinkConnection = new MultiLinkConnection(node, (Node)serializable);
            this.finalPathList.addElement(multiLinkConnection);
        }
        int n = this.destToSrcPathList.size() - 1;
        while (n >= 0) {
            node = this.destToSrcPathList.elementAt(n);
            this.finalPathList.addElement((Connection)((Object)node));
            --n;
        }
        int n2 = 0;
        while (n2 < this.finalPathList.size()) {
            serializable = (Connection)this.finalPathList.elementAt(n2);
            ((Connection)serializable).setConnections(this.finalPathList);
            ++n2;
        }
    }

    protected Node getLastNode(Vector vector, Node node) {
        Node node2;
        int n = vector.size();
        if (n == 0) {
            node2 = node;
        } else if (n == 1) {
            Connection connection = (Connection)vector.firstElement();
            node2 = connection.getOtherNode(node);
        } else {
            Connection connection = (Connection)vector.elementAt(n - 1);
            Connection connection2 = (Connection)vector.elementAt(n - 2);
            Node node3 = connection.getCommonNode(connection2);
            node2 = connection.getOtherNode(node3);
        }
        return node2;
    }

    protected void remoteTracePathQuery(Node node) throws RemoteTraceException {
        Connection connection;
        IPAddress iPAddress;
        int n;
        Object[][] objectArray = null;
        Object[][] objectArray2 = null;
        Node node2 = null;
        Node node3 = null;
        Integer n2 = null;
        if (node != this.src) {
            this.notifyStatusListeners(this, "Attempting to use trace from " + node.getIPAddress() + " to " + this.src.getIPAddress() + " using remote trace");
            try {
                objectArray = node.remoteTrace(this.src);
            }
            catch (RemoteTraceException remoteTraceException) {
                this.notifyStatusListeners(node, String.valueOf(node.getIPAddress()) + " does not support remote trace");
                throw remoteTraceException;
            }
            n = objectArray.length - 1;
            while (n >= 0) {
                iPAddress = (IPAddress)objectArray[n][0];
                node3 = new Node(iPAddress, this.options.communityName, this.options.voyagerAddress);
                if (node2 != null) {
                    connection = new Connection(node2, node3, n2);
                    this.finalPathList.addElement(connection);
                }
                n2 = (Integer)objectArray[n][1];
                node2 = node3;
                --n;
            }
            connection = new Connection(node3, node, n2);
            this.finalPathList.addElement(connection);
        }
        if (node != this.dest) {
            this.notifyStatusListeners(this, "Attempting to use trace from " + node.getIPAddress() + " to " + this.dest.getIPAddress() + " using remote trace");
            try {
                objectArray2 = node.remoteTrace(this.dest);
            }
            catch (RemoteTraceException remoteTraceException) {
                this.notifyStatusListeners(node, String.valueOf(node.getIPAddress()) + " does not support remote trace");
                throw remoteTraceException;
            }
            node2 = node;
            n = 0;
            while (n < objectArray2.length) {
                iPAddress = (IPAddress)objectArray2[n][0];
                n2 = (Integer)objectArray2[n][1];
                node3 = new Node(iPAddress, this.options.communityName, this.options.voyagerAddress);
                connection = new Connection(node2, node3, n2);
                this.finalPathList.addElement(connection);
                node2 = node3;
                ++n;
            }
        }
        this.pathComplete = true;
    }

    public void addStatusListener(StatusListener statusListener) {
        if (this.statusListeners == null) {
            this.statusListeners = new Vector();
        }
        this.statusListeners.addElement(statusListener);
    }

    public void removeStatusListener(StatusListener statusListener) {
        if (this.statusListeners != null) {
            this.statusListeners.removeElement(statusListener);
        }
    }

    protected void notifyStatusListeners(Object object, String string) {
        if (this.statusListeners == null) {
            return;
        }
        StatusEvent statusEvent = new StatusEvent(object, string);
        Enumeration enumeration = this.statusListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((StatusListener)enumeration.nextElement()).statusEventOccurred(statusEvent);
        }
    }

    public String toString() {
        String string;
        try {
            string = System.getProperty("line.separator");
        }
        catch (SecurityException securityException) {
            string = "\n";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.getConnections();
        try {
            while (enumeration.hasMoreElements()) {
                Connection connection = (Connection)enumeration.nextElement();
                stringBuffer.append(connection.toString());
                stringBuffer.append(string);
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
        return stringBuffer.toString();
    }

    public void debugDump() {
        Object object;
        System.out.println("-------------- Start Connections ------------");
        Enumeration enumeration = this.getConnections();
        try {
            while (enumeration.hasMoreElements()) {
                object = (Connection)enumeration.nextElement();
                ((Connection)object).debugDump();
                System.out.println();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.out.println(noSuchElementException);
        }
        System.out.println("-------------- Start Nodes ------------");
        object = this.getNodes();
        try {
            while (object.hasMoreElements()) {
                Node node = (Node)object.nextElement();
                node.debugDump(false);
                System.out.println();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.out.println(noSuchElementException);
        }
        System.out.println();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class NodeEnumeration
    implements Enumeration {
        private Node currNode;
        private Enumeration connections;

        public NodeEnumeration() {
            Path.this = Path.this;
            this.currNode = Path.this.getSrcNode();
            this.connections = Path.this.getConnections();
        }

        public boolean hasMoreElements() {
            return this.currNode != null;
        }

        public Object nextElement() {
            Node node = this.currNode;
            try {
                if (this.connections.hasMoreElements()) {
                    Connection connection = (Connection)this.connections.nextElement();
                    this.currNode = connection.getOtherNode(this.currNode);
                } else {
                    this.currNode = null;
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
            return node;
        }
    }
}

